#Circular diagram creation from EST sequences present in samples 
#preparing the tables
# Abundance table compromises all of the unique peptides that support proteins found in each of the beads which and are also present in reference species (S).
# Oto table indicates the coverage of each protein found in the beads that also belong to reference shells S.  
abundance <- read.csv("M3. Bead uniqueP.csv", header=TRUE,row.names=1,check.names=FALSE)
oto <- read.csv("M2. CovEST.csv", header = TRUE)
oto[is.na(oto)] <- 0

species = intersect(colnames(abundance), oto[[2]])
abundance = abundance[, species]
beads = rownames(abundance)[c(1:7)]
beads

#seting colours
library(RColorBrewer)
col1 = brewer.pal(7, "Set2")
names(col1) = species
col2 = brewer.pal(length(beads), "Set3")
names(col2) = beads

#
df = NULL
for(type in beads) {
  for(s in species) {
    l = oto[[2]] == s
    n = sum(l)
    n = 1
    dd = data.frame(type = rep(type, n), species = rep(s, n), vaule1 = abundance[type, s], value2 = sum(oto[l, type]))
    df = rbind(df, dd)
  }
}

df[[1]] = as.character(df[[1]])
df[[2]] = as.character(df[[2]])

sector = NULL
sector_xlim = NULL
for(t in unique(df[[1]])) {
  sector = c(sector, t)
  sector_xlim = rbind(sector_xlim, c(0, sum(df[df[[1]] == t, 3])))
}
for(t in unique(df[[2]])) {
  sector = c(sector, t)
  sector_xlim = rbind(sector_xlim, c(0, sum(df[df[[2]] == t, 4])))
}

library(circlize)
#initialise circle
circos.par(cell.padding = c(0, 0, 0, 0), start.degree = 270, gap.degree = c(1, 1, 1, 1, 1, 1, 10, 1, 1, 1, 3, 3, 10))


circos.initialize(factors = factor(sector, levels = sector), xlim = sector_xlim,
                  sector.width = c(sector_xlim[1:7,2]/sum(sector_xlim[1:7,2]), 1*sector_xlim[8:13,2]/sum(sector_xlim[8:13,2])))


circos.trackPlotRegion(ylim = c(0, 1), panel.fun = function(x, y) {
  sector.index = get.cell.meta.data("sector.index")
  if(sector.index %in% sector[8:13]) {
    xlim = get.cell.meta.data("xlim")
    ylim = get.cell.meta.data("ylim")
    l = oto[[2]] == sector.index
    x = seq(0, by = 3, length = sum(l))
    x = x + mean(xlim) - mean(x)
    circos.rect(xlim[1], ylim[1], xlim[2], ylim[2], col = col1[sector.index], border = NA)
  }
}, bg.border = NA, track.height = 0.08)


circos.trackPlotRegion(ylim = c(0, 1), panel.fun = function(x, y) {
  sector.index = get.cell.meta.data("sector.index")
  xlim = get.cell.meta.data("xlim")
  ylim = get.cell.meta.data("ylim")
  circos.text(mean(xlim), mean(ylim), sector.index, cex = 0.8, adj = c(0.5, 0.5), facing = "clockwise",font = 2, niceFacing = TRUE)
}, track.height = 0.3, bg.border = NA)

circos.trackPlotRegion(ylim = c(0, 1), panel.fun = function(x, y) {
  circos.axis(h = "top", labels.cex = 0.4, major.tick.percentage = 0.4)
}, track.height = 0.02, bg.col = c(col2, col1), track.margin = c(0, 0.01))

circos.trackPlotRegion(ylim = c(0, 1), panel.fun = function(x, y) {
}, track.height = 0.02, track.margin = c(0, 0.01))

accum_species = sapply(species, function(x) get.cell.meta.data("xrange", sector.index = x)); names(accum_species) = species

accum_beads = sapply(beads, function(x) get.cell.meta.data("xrange", sector.index = x)); names(accum_beads) = beads
for(i in seq_len(nrow(df))) {
  circos.link(df[i,1], c(accum_beads[df[i,1]], accum_beads[df[i,1]] - df[i, 3]),
              df[i,2], c(accum_species[df[i,2]], accum_species[df[i,2]] - df[i, 4]),
              col = paste0(col1[df[i,2]], "80"), border = NA)
  
  circos.rect(accum_beads[df[i,1]], 0, accum_beads[df[i,1]] - df[i, 3], 1, sector.index = df[i,1], col = col1[df[i,2]])
  circos.rect(accum_species[df[i,2]], 0, accum_species[df[i,2]] - df[i, 4], 1, sector.index = df[i,2], col = col2[df[i,1]])
  
  accum_beads[df[i,1]] = accum_beads[df[i,1]] - df[i, 3]
  accum_species[df[i,2]] = accum_species[df[i,2]] - df[i, 4]
}

circos.clear()

